const express = require('express');
const router = express.Router();
const {
  listFAQs,
  getFAQ,
  createFAQ,
  updateFAQ,
  deleteFAQ
} = require('../controller/faqs')


// Routes
router.get('/faqs', listFAQs);
router.get('/faqs/:id', getFAQ);
router.post('/faqs', createFAQ);
router.put('/faqs/:id', updateFAQ);
router.delete('/faqs/:id', deleteFAQ);

module.exports = router;
