// routes/coverTemplates.js
const path = require("path");
const fs = require("fs");
const express = require("express");
const multer = require("multer");
const ctrl = require("../controller/CoverTemplateController");

const router = express.Router();

// Ensure the static folder exists
const uploadRoot = path.join(__dirname, "..", "public", "templete");
if (!fs.existsSync(uploadRoot)) {
  fs.mkdirSync(uploadRoot, { recursive: true });
}

// Multer storage that saves into public/templete
const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, uploadRoot);
  },
  filename: function (req, file, cb) {
    const safe = file.originalname.replace(/\s+/g, "_");
    cb(null, Date.now() + "_" + safe);
  },
});
const upload = multer({ storage });

// Public list
router.get("/", ctrl.list);

// Admin create with file upload
// Send multipart form with fields: title, description optional
// Files: asset required, preview optional
router.post(
  "/",
  upload.fields([
    { name: "asset", maxCount: 1 },
    { name: "preview", maxCount: 1 },
  ]),
  ctrl.create
);

// Optional update and soft delete for management
router.patch("/:id", ctrl.update);
router.delete("/:id", ctrl.remove);

module.exports = router;
