// models/User.js

const { DataTypes, Model } = require("sequelize");
const sequelize = require("../config/database");
const defineAssociations = require("./defineAssociations");
const CoAdmins = require("./CoAdmins");

const User = sequelize.define(
  "User",
  {
    userid: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    firstName: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    lastName: {
      type: DataTypes.STRING,
    },
    email: {
      type: DataTypes.STRING,
      allowNull: false,
      unique: true,
      validate: {
        isEmail: true,
      },
    },
    password: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    type: {
      type: DataTypes.ENUM(
        "super_admin",
        "admin",
        "user",
        "service_provider",
      ),
      allowNull: false,
      defaultValue: "user",
    },
    companydescription: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    companyname: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    service_id: {
      type: DataTypes.INTEGER,
      allowNull: true, // only for service_provider
      references: {
        model: "services",
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },

    town: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    state: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    country: {
      type: DataTypes.STRING,
      allowNull: true,
    },
  },
  {
    tableName: "User",
    timestamps: false,
  }
);
CoAdmins.belongsTo(User, { foreignKey: "user_id", as: "user" });


async function migrate() {
  try {
    await sequelize.sync({ alter: true });
    console.log("Migration successful");
  } catch (error) {
    console.error("Migration failed:", error);
  }
}
module.exports = User;
