// models/Testimonial.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // Import the User model

const Testimonial = sequelize.define(
  "Testimonial",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    userId: {
      type: DataTypes.INTEGER,
      allowNull: false,
      field: "user_id",
    },
    isActive: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true,
      field: "IsActive",
    },
    Title :{
      type: DataTypes.STRING,
      allowNull: true,
    },
    createdBy: {
      type: DataTypes.STRING,
      allowNull: true,
      field: "CreatedBy",
    },
    createdOn: {
      type: DataTypes.DATE,
      allowNull: true,
      field: "CreatedOn",
    },
    reviewDescription: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      field: "ReviewDescription",
    },
  },
  {
    tableName: "testimonial",
    timestamps: false,
  }
);

// Define association with User model
Testimonial.belongsTo(User, { foreignKey: "userId" });

module.exports = Testimonial;
