const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // Import the User model

const Subscription = sequelize.define(
  "Subscription",
  {
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: User,
        key: "userid",
      },
    },
    subscriptionId: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    details: {
      type: DataTypes.TEXT("long"),
    },
  },
  {
    tableName: "subscription",
    timestamps: true,
  }
);

// Define association with User model
Subscription.belongsTo(User, { foreignKey: "user_id", as: "user" });

// async function migrate() {
//   try {
//     await Subscription.sync({ force: true });
//     console.log("Migration successful");
//   } catch (error) {
//     console.error("Migration failed:", error);
//   }
// }

// migrate();

module.exports = Subscription;
