const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");

const SocialMedia = sequelize.define(
  "SocialMedia",
  {
    title: DataTypes.STRING,
    url: DataTypes.STRING,
  },
  {
    tableName: "social_media",
    timestamps: false,
  }
);

async function migrate() {
  try {
    await SocialMedia.sync({ force: true }); // This will create the table for all defined models
    console.log("Migration successful");
  } catch (error) {
    console.error("Migration failed:", error);
  }
}

migrate();

module.exports = SocialMedia;
