// models/Testimonial.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // Import the User model

const ServiceTestimonial = sequelize.define(
  "ServiceTestimonial",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    userId: {
      type: DataTypes.INTEGER,
      allowNull: false,
      field: "user_id",
    },
    serviceId: {            
      type: DataTypes.INTEGER,
      allowNull: false,
      field: "service_id",  
    },
    isActive: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true,
      field: "IsActive",
    },
    createdBy: {
      type: DataTypes.STRING,
      allowNull: true,
      field: "CreatedBy",
    },
    createdOn: {
      type: DataTypes.DATE,
      allowNull: true,
      field: "CreatedOn",
    },
    reviewDescription: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      field: "ReviewDescription",
    },
  },
  {
    tableName: "serviceTestimonial",
    timestamps: false,
  }
);

// Define association with User model
ServiceTestimonial.belongsTo(User, { foreignKey: "userId" });
ServiceTestimonial.belongsTo(User, { foreignKey: "service_id"});


module.exports = ServiceTestimonial;
