// models/HelpMessage.js
const { DataTypes } = require("sequelize");
const sequelize = require("../config/database");
const User = require("./User"); // :contentReference[oaicite:2]{index=2}
const HelpThread = require("./HelpThread");

const HelpMessage = sequelize.define("HelpMessage", {
  id: { type: DataTypes.INTEGER, primaryKey: true, autoIncrement: true },
  thread_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: { model: HelpThread, key: "id" },
  },
  sender_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: { model: User, key: "userid" },
  },
  body: { type: DataTypes.TEXT("long"), allowNull: false },
}, {
  tableName: "help_messages",
  timestamps: true,
});
module.exports = HelpMessage;
