const jwt = require("jsonwebtoken");
const CoAdmins = require("../models/CoAdmins");
const Memorial = require("../models/Memorial");
const Obituary = require("../models/Obituary");
const Traibute = require("../models/TraibuteModel");

module.exports = {
  authenticateToken(req, res, next) {
    const authHeader = req.headers["authorization"];

    if (!authHeader || !authHeader.startsWith("Bearer ")) {
      return res
        .status(401)
        .json({ error: "Unauthorized - No token provided or invalid format" });
    }

    const token = authHeader.split(" ")[1];
    console.log({ token });

    if (!token) {
      return res
        .status(401)
        .json({ error: "Unauthorized - No token provided" });
    }

    jwt.verify(token, process.env.SECRETKEY, (err, decoded) => {
      if (err) {
        return res.status(403).json({ error: "Forbidden - Invalid token" });
      }
      req.userId = decoded.userId;
      next();
    });
  },

  async checkSuperAdmin(req, res, next) {
    const user = await req.user;
    if (user.type === "super_admin") {
      next();
    } else {
      return res.status(401).json({ message: "Unauthorized" });
    }
  },

  async checkCoAdmin(req, res, next) {
    const user = await req.user;
    if (user.type === "super_admin") {
      return next();
    }
    const coAdmin = await CoAdmins.findOne({
      where: { user_id: req.user.userid, memorial_id: req.params.memorialId },
    });

    if (!coAdmin) return res.status(401).json({ message: "Unauthorized" });
    next();
  },

  async checkMemorialOwner(req, res, next) {
    try {
      const user = await req.user;
      const memorial = await Memorial.findOne({
        where: { id: req.params.memorialId },
      });
      if (user.type === "super_admin") {
        next();
      } else if (memorial.user_id === user.userid) {
        next();
      } else {
        return res.status(401).json({ message: "Unauthorized" });
      }
    } catch (err) {
      console.log({ err });
    }
  },

  async checkObituaryOwner(req, res, next) {
    try {
      const user = await req.user;
      const obituary = await Obituary.findOne({
        where: { user_id: user.userid, id: req.params.id },
      });
      if (user.type === "super_admin") {
        next();
      } else if (obituary.user_id === user.userid) {
        next();
      } else {
        return res.status(401).json({ message: "Unauthorized" });
      }
    } catch (err) {
      console.log({ err });
    }
  },

  async checkTributeOwner(req, res, next) {
    try {
      const user = await req.user;
      const tribute = await Traibute.findOne({
        where: { userId: user.userid, id: req.params.id },
      });
      console.log({ tribute });
      if (user.type === "super_admin") {
        next();
      } else if (tribute.userId === user.userid) {
        next();
      } else {
        return res.status(401).json({ message: "Unauthorized" });
      }
    } catch (err) {
      console.log({ err });
    }
  },
};
