const nodemailer = require('nodemailer');
const { smtpUser, smtpPass } = require('../config/config');
const transporter = nodemailer.createTransport({
    host: 'smtp-mail.outlook.com',
    port: 587,
    secure: false, // true for 465, false for other ports
    auth: {
        user: smtpUser,
        pass: smtpPass,
    },
});

// google config 
// service: "Gmail",
// host: "smtp.gmail.com",
// port: 465,
// secure: true,


const sendMail = async (userEmail) => {


    // Email details
    const mailOptions = {
        from: smtpUser,
        to: userEmail,
        subject: 'Welcome to Brainwise Institute: Your Hub for IQ and Brain Games!',
        text: `
Welcome to Brainwise Institute, your premier destination for IQ tests and a variety of stimulating brain games! We're delighted to have you join our community of eager minds seeking fun, challenge, and intellectual growth.

Here at Brainwise Institute, we're dedicated to providing you with a diverse array of IQ tests and brain games designed to entertain, educate, and engage. Whether you're here to measure your cognitive abilities, sharpen your problem-solving skills, or simply enjoy some brain-teasing fun, you've come to the right place.

Our platform offers an extensive selection of IQ tests that cater to different aspects of intelligence, allowing you to discover your strengths and areas for improvement. Additionally, our collection of brain games spans across various categories, including logic puzzles, memory challenges, spatial reasoning tasks, and more, ensuring there's always something new and exciting to explore.

But Brainwise Institute is more than just a platform for testing and gaming—it's a vibrant community where individuals come together to share their passion for mental stimulation and personal development. Connect with like-minded members, engage in friendly competition, and collaborate on solving tricky puzzles to unlock new levels of cognitive achievement.

Whether you're a casual gamer looking for a fun way to exercise your brain or a serious enthusiast striving for peak mental performance, Brainwise Institute has something for everyone. So dive in, challenge yourself, and let the games begin!

Once again, welcome to Brainwise Institute. We're thrilled to have you join us on this journey of discovery and enrichment.

Best regards,

Brainwise Institute Team`,
        // html: '<p>Hello, this is a test email!</p>' // You can use HTML content
    };

    // Send the email
    transporter.sendMail(mailOptions, (error, info) => {
        if (error) {

            console.error('Error sending email ', error)
            // return res.status(500).json({ error: '', details: error });
            return { message: 'Error sending email', details: error, success: false }
        }
        console.log('Email sent successfully ', info.response)
        // Email sent successfully

        return { message: 'Email sent successfully', details: info.response, success: true }
        // res.status(200).json({ message: ', details:  });
    });


}

module.exports = {
    sendMail,
}