const HelpTicket = require("../models/HelpTicket");
const nodemailer = require("nodemailer");
require("dotenv").config();

// Setup nodemailer transporter (your config)
const transporter = nodemailer.createTransport({
  service: "gmail",
  auth: {
    user: process.env.ADMIN_EMAIL,
    pass: process.env.ADMIN_PASSWORD,
  },
});

exports.createTicket = async (req, res) => {
  try {
    const { user_id, email, subject, message } = req.body;
    if (!user_id || !email || !subject || !message) {
      return res.status(400).json({ error: "Missing required fields" });
    }

    const newTicket = await HelpTicket.create({
      user_id,
      email,
      subject,
      messages: [{ sender_id: user_id, message, created_at: new Date() }],
    });

    // Send email to admin
    const mailOptions = {
      from: email,
      to: "your_admin_email@gmail.com",
      subject: `New Help Ticket: ${subject}`,
      text: `User Email: ${email}\n\nMessage:\n${message}`,
    };
    transporter.sendMail(mailOptions, (error) => {
      if (error) console.error("Email error:", error);
    });

    res.status(201).json({ ticket_id: newTicket.id, message: "Ticket created" });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: "Server error" });
  }
};

exports.getTicketsByUser = async (req, res) => {
  try {
    const user_id = req.params.user_id;
    const tickets = await HelpTicket.findAll({
      where: { user_id },
      order: [["created_at", "DESC"]],
    });
    res.json(tickets);
  } catch (err) {
    res.status(500).json({ error: "Server error" });
  }
};

exports.addMessage = async (req, res) => {
  try {
    const { ticket_id, sender_id, message } = req.body;
    if (!ticket_id || !sender_id || !message) {
      return res.status(400).json({ error: "Missing required fields" });
    }

    const ticket = await HelpTicket.findByPk(ticket_id);
    if (!ticket) return res.status(404).json({ error: "Ticket not found" });

    const updatedMessages = ticket.messages;
    updatedMessages.push({ sender_id, message, created_at: new Date() });

    ticket.messages = updatedMessages;
    await ticket.save();

    res.json({ message: "Message added" });
  } catch (err) {
    res.status(500).json({ error: "Server error" });
  }
};
