const FAQ = require("../models/Faq");

async function listFAQs(req, res) {
  const faqs = await FAQ.findAll();
  res.json(faqs);
}

async function getFAQ(req, res) {
  const faq = await FAQ.findByPk(req.params.id);
  if (!faq) return res.status(404).json({ error: 'FAQ not found' });
  res.json(faq);
}

async function createFAQ(req, res) {
  const { question, answer } = req.body;
  const faq = await FAQ.create({ question, answer });
  res.status(201).json(faq);
}

async function updateFAQ(req, res) {
  const { question, answer } = req.body;
  const faq = await FAQ.findByPk(req.params.id);
  if (!faq) return res.status(404).json({ error: 'FAQ not found' });
  faq.question = question;
  faq.answer = answer;
  await faq.save();
  res.json(faq);
}

async function deleteFAQ(req, res) {
  const faq = await FAQ.findByPk(req.params.id);
  if (!faq) return res.status(404).json({ error: 'FAQ not found' });
  await faq.destroy();
  res.status(204).send();
}

module.exports = {
  listFAQs,
  getFAQ,
  createFAQ,
  updateFAQ,
  deleteFAQ,
};
